#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_Latch.h"

namespace {
bool unrom;

void sync0 (void) {
	if (Latch::addr &1)
		EMU->SetPRG_ROM32(0x8, Latch::addr >>2);
	else {
		EMU->SetPRG_ROM16(0x8, Latch::addr >>1);
		EMU->SetPRG_ROM16(0xC, Latch::addr >>1);
	}
	EMU->SetCHR_ROM8(0, Latch::data >>1);
	if (Latch::data &0x01)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

void sync1 (void) {
	int mask = (ROM->PRGROMSize -0x20001) >>14;
	if (unrom) {
		mask++;
		EMU->SetPRG_ROM16(0x8, Latch::data &7 | mask);
		EMU->SetPRG_ROM16(0xC,              7 | mask);
		EMU->SetCHR_RAM8(0x0, 0);
		EMU->Mirror_V();
	} else {
		if (Latch::addr &1)
			EMU->SetPRG_ROM32(0x8, Latch::addr >>2 & (mask >>1));
		else {
			EMU->SetPRG_ROM16(0x8, Latch::addr >>1 &mask);
			EMU->SetPRG_ROM16(0xC, Latch::addr >>1 &mask);
		}
		EMU->SetCHR_ROM8(0, Latch::data >>1);
		if (Latch::data &0x01)
			EMU->Mirror_H();
		else
			EMU->Mirror_V();
	}
}

BOOL MAPINT load (void) {
	Latch::load(ROM->INES2_SubMapper == 1? sync1: sync0, NULL);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	if (ROM->INES2_SubMapper ==1) unrom = resetType == RESET_HARD? false: !unrom;
	Latch::reset(RESET_HARD);
}

uint16_t mapperNum =438;
} // namespace

MapperInfo MapperInfo_438 ={
	&mapperNum,
	_T("K-3071/K-3014"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	Latch::saveLoad_AD,
	NULL,
	NULL
};